// Copyright (c) Paul Agron
//
// Permission is hereby granted, free of charge, to any person
// obtaining a copy of this software and associated documentation
// files (the "Software"), to deal in the Software without
// restriction, including without limitation the rights to use,
// copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following
// conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//
// If you use it, acknowledgement in an About Page or other appropriate place is required.
// For example, "Contains "KTUIKit" by Paul Agron" will do.


#pragma once

//
// There should be ONLY one instance of Configurator View !!!
// 

@interface SYConfiguratorView : NSView 
{
#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_5
    NSView* rootView;
    NSTableView* tableView;
#else
    IBOutlet NSView* rootView;
    IBOutlet NSTableView* tableView;
#endif
    NSMutableArray* rows;
    NSMutableString* applicationSupportSubfolder;
}

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_5
@property (nonatomic, readwrite, retain) IBOutlet NSView* rootView;
@property (nonatomic, readwrite, retain) IBOutlet NSTableView* tableView;
#endif

-(IBAction) addExpression:(id)sender;
-(IBAction) removeSelectedExpression:(id)sender;
-(void) setApplicationSupportSubfolder:(NSString*)path;
+(NSString*)archiveFilename;

@end
